<section id="page-title">

    <div class="container clearfix">

        <h1><?php echo __('User Profile'); ?></h1>
            <ol class="breadcrumb">
                <li><a href="<?php echo ROOT_PATH; ?>index.php">Home &nbsp;&nbsp;</a></li>
                <li>/</li>
                <li class="active"><a href="<?php echo ROOT_PATH; ?>profile.php">&nbsp;&nbsp; User Profile</a></li>
            </ol>

    </div>

</section>

<section id="content nobottommargin">

    <div class="content-wrap">

        <div class="container clearfix">

            <h3><?php echo __('Manage Your Profile Information'); ?></h3>
                <p><?php echo __(
                'Use the forms below to update the information we have on file for your account'
                ); ?>
                </p>

            <form action="profile.php" method="post">
              <?php csrf_token(); ?>
            <table width="800" class="padded">
            <?php
            foreach ($user->getForms() as $f) {
                $f->render(false);
            }
            if ($acct = $thisclient->getAccount()) {
                $info=$acct->getInfo();
                $info=Format::htmlchars(($errors && $_POST)?$_POST:$info);
            ?>
            <tr>
                <td colspan="2">
                    <div><hr><h3><?php echo __('Preferences'); ?></h3>
                    </div>
                </td>
            </tr>
                <tr>
                    <td width="180">
                        <?php echo __('Time Zone');?>:
                    </td>
                    <td>
                        <?php
                        $TZ_NAME = 'timezone';
                        $TZ_TIMEZONE = $info['timezone'];
                        include INCLUDE_DIR.'staff/templates/timezone.tmpl.php'; ?>
                        <div class="error"><?php echo $errors['timezone']; ?></div>
                    </td>
                </tr>
            <?php if ($cfg->getSecondaryLanguages()) { ?>
                <tr>
                    <td width="180">
                        <?php echo __('Preferred Language'); ?>:
                    </td>
                    <td>
                <?php
                $langs = Internationalization::getConfiguredSystemLanguages(); ?>
                        <select name="lang">
                            <option value="">&mdash; <?php echo __('Use Browser Preference'); ?> &mdash;</option>
            <?php foreach($langs as $l) {
            $selected = ($info['lang'] == $l['code']) ? 'selected="selected"' : ''; ?>
                            <option value="<?php echo $l['code']; ?>" <?php echo $selected;
                                ?>><?php echo Internationalization::getLanguageDescription($l['code']); ?></option>
            <?php } ?>
                        </select>
                        <span class="error">&nbsp;<?php echo $errors['lang']; ?></span>
                    </td>
                </tr>
            <?php }
                  if ($acct->isPasswdResetEnabled()) { ?>
            <tr>
                <td colspan="2">
                    <div><hr><h3><?php echo __('Access Credentials'); ?></h3></div>
                </td>
            </tr>
            <?php if (!isset($_SESSION['_client']['reset-token'])) { ?>
            <tr>
                <td width="180">
                    <?php echo __('Current Password'); ?>:
                </td>
                <td>
                    <input type="password" size="18" name="cpasswd" value="<?php echo $info['cpasswd']; ?>">
                    &nbsp;<span class="error">&nbsp;<?php echo $errors['cpasswd']; ?></span>
                </td>
            </tr>
            <?php } ?>
            <tr>
                <td width="180">
                    <?php echo __('New Password'); ?>:
                </td>
                <td>
                    <input type="password" size="18" name="passwd1" value="<?php echo $info['passwd1']; ?>">
                    &nbsp;<span class="error">&nbsp;<?php echo $errors['passwd1']; ?></span>
                </td>
            </tr>
            <tr>
                <td width="180">
                    <?php echo __('Confirm New Password'); ?>:
                </td>
                <td>
                    <input type="password" size="18" name="passwd2" value="<?php echo $info['passwd2']; ?>">
                    &nbsp;<span class="error">&nbsp;<?php echo $errors['passwd2']; ?></span>
                </td>
            </tr>
            <?php } ?>
            <?php } ?>
            </table>
            <hr>
            <p style="text-align: center;">
                <input class="button button-3d button-green nomargin" type="submit" value="Update"/>
                <input class="button button-3d button-teal nomargin" type="reset" value="Reset"/>
                <input class="button button-3d button-desc nomargin" type="button" value="Cancel" onclick="javascript:
                    window.location.href='index.php';"/>
            </p>
            </form>
