<section id="page-title">

    <div class="container clearfix">
    
        <?php
        $info = $_POST;
        if (!isset($info['timezone']))
            $info += array(
                'backend' => null,
            );
        if (isset($user) && $user instanceof ClientCreateRequest) {
            $bk = $user->getBackend();
            $info = array_merge($info, array(
                'backend' => $bk::$id,
                'username' => $user->getUsername(),
            ));
        }
        $info = Format::htmlchars(($errors && $_POST)?$_POST:$info);

        ?>

        <h1><?php echo __('Account Registration'); ?></h1>
            <ol class="breadcrumb">
                <li><a href="<?php echo ROOT_PATH; ?>index.php">Home &nbsp;&nbsp;</a></li>
                <li>/</li>
                <li class="active"><a href="<?php echo ROOT_PATH; ?>register.php">&nbsp;&nbsp; Account Registration</a></li>
            </ol>
        

    </div>

</section>

<section id="content nobottommargin">

    <div class="content-wrap">

        <div class="container clearfix" >

            <form action="account.php" id="register-form" name="register-form" class="nobottommargin" method="post">
              <?php csrf_token(); ?>
              <input type="hidden" name="do" value="<?php echo Format::htmlchars($_REQUEST['do']
                ?: ($info['backend'] ? 'import' :'create')); ?>" />
            
                <div>
                    <?php
                        $cf = $user_form ?: UserForm::getInstance();
                        $cf->render(false, false, array('mode' => 'create'));
                    ?>
                    <tr>
                        <td colspan="2">
                            <div><hr><h3><?php echo __('Preferences'); ?></h3>
                            </div>
                        </td>
                    </tr>
                        <div>
                            <td width="180">
                                <?php echo __('Time Zone');?>:
                            </td>
                            <td class="sm-form-control">
                                <?php
                                $TZ_NAME = 'timezone';
                                $TZ_TIMEZONE = $info['timezone'];
                                include INCLUDE_DIR.'staff/templates/timezone.tmpl.php'; ?>
                                <div class="error"><?php echo $errors['timezone']; ?></div>
                            </td>
                        </tr>
                    <tr>
                        <td colspan="2">
                            <div><hr><h3><?php echo __('Access Credentials'); ?></h3></div>
                        </td>
                    </tr>
                    <?php if ($info['backend']) { ?>
                    <tr>
                        <td width="180">
                            <?php echo __('Login With'); ?>:
                        </td>
                        <td>
                            <div class="col_half">
                            <input type="hidden" name="backend" value="<?php echo $info['backend']; ?>"/>
                            <input type="hidden" name="username" value="<?php echo $info['username']; ?>"/>
                            </div>
                    <?php foreach (UserAuthenticationBackend::allRegistered() as $bk) {
                        if ($bk::$id == $info['backend']) {
                            echo $bk->getName();
                            break;
                        }
                    } ?>
                        </td>
                    </tr>
                    <?php } else { ?>


                    <div class="col_one_third">
                        <label for="template-contactform-name">Create Password<small>*</small></label>
                        <td>
                            <input class="form-control" type="password" size="18" name="passwd1" value="<?php echo $info['passwd1']; ?>">
                            &nbsp;<span class="error">&nbsp;<?php echo $errors['passwd1']; ?></span>
                        </td>
                    </div>
                    <div class="col_one_third">
                        <label for="template-contactform-name">Re-Enter Password<small>*</small></label>
                        <td>
                            <input class="form-control" type="password" size="18" name="passwd2" value="<?php echo $info['passwd2']; ?>">
                            &nbsp;<span class="error">&nbsp;<?php echo $errors['passwd2']; ?></span>
                        </td>
                    </tr>
                    <?php } ?>
                </div>

               <div class="clear"></div>
                    <div class="col_two_third">
                        <p style="text-align: center;color: #fff;">
                            <input class="button button-3d button-green nomargin" id="register-form-submit" type="submit" value="Register" style="color: rgb(255, 255, 255) !important;"/>
                            <input class="button button-3d button nomargin" id="register-form-submit" type="button" value="Cancel" onclick="javascript:
                                window.location.href='index.php';"/>
                        </p>
                    </div>
                </div>        
            </form>

            <?php if (!isset($info['timezone'])) { ?>
            <!-- Auto detect client's timezone where possible -->
            <script type="text/javascript" src="<?php echo ROOT_PATH; ?>js/jstz.min.js?035fd0a"></script>
            <script type="text/javascript">
            $(function() {
                var zone = jstz.determine();
                $('#timezone-dropdown').val(zone.name()).trigger('change');
            });
            </script>
            <?php } ?>
        </div>
    </div>
</section>