<div wire:click.stop id="menu-notifications" class="relative">
    <input type="text" name="notification_keyword" wire:model.debounce.500ms="keyword" placeholder="<?php echo e(trans('general.search_placeholder')); ?>" class="border-t-0 border-l-0 border-r-0 border-b border-gray-300 bg-transparent text-gray-500 text-sm mb-3 focus:outline-none focus:ring-transparent focus:border-purple placeholder-light-gray js-search-action">

    <?php if($keyword): ?>
        <button type="button" class="absolute ltr:right-2 rtl:left-2 top-2 clear" wire:click="resetKeyword">
            <span class="material-icons text-sm">close</span>
        </button>
    <?php endif; ?>

    <?php if($notifications): ?>
        <div class="flex justify-end mt-1 mb-3">
            <?php if (isset($component)) { $__componentOriginal284f9feb63bd47ce2d3752d7a9d26b19b33cab56 = $component; } ?>
<?php $component = $__env->getContainer()->make(App\View\Components\Tooltip::class, ['id' => 'notification-all','placement' => 'top','message' => ''.e(trans('notifications.mark_read_all')).''] + (isset($attributes) ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('tooltip'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $constructor = (new ReflectionClass(App\View\Components\Tooltip::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
                <button type="button" wire:click="markReadAll()">
                    <span id="menu-notification-read-all" class="material-icons text-lg text-purple hover:scale-125">done_all</span>
                </button>
             <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal284f9feb63bd47ce2d3752d7a9d26b19b33cab56)): ?>
<?php $component = $__componentOriginal284f9feb63bd47ce2d3752d7a9d26b19b33cab56; ?>
<?php unset($__componentOriginal284f9feb63bd47ce2d3752d7a9d26b19b33cab56); ?>
<?php endif; ?>
        </div>

        <ul class="flex flex-col justify-center">
            <?php $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if(empty($notification->data['title']) && empty($notification->data['description'])): ?>
                    <?php continue; ?>
                <?php endif; ?>

                <li class="mb-5 border-b pb-2">
                    <div class="flex items-start justify-between font-medium text-sm text-purple mb-1">
                        <div class="flex flex-col">
                            <?php echo $notification->data['title']; ?>


                            <span class="text-gray-500" style="font-size: 10px;">
                                <?php echo e(\Carbon\Carbon::createFromTimeStamp(strtotime($notification->created_at))->diffForHumans()); ?>

                            </span>
                        </div>

                        <?php if($notification->type != 'updates'): ?>
                            <?php if (isset($component)) { $__componentOriginal284f9feb63bd47ce2d3752d7a9d26b19b33cab56 = $component; } ?>
<?php $component = $__env->getContainer()->make(App\View\Components\Tooltip::class, ['id' => 'notification-'.e($notification->id).'','placement' => 'top','message' => ''.e(trans('notifications.mark_read')).''] + (isset($attributes) ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('tooltip'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $constructor = (new ReflectionClass(App\View\Components\Tooltip::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
                                <button type="button" wire:click="markRead('<?php echo e($notification->type); ?>', '<?php echo e($notification->id); ?>')">
                                    <span id="menu-notification-mark-read" class="material-icons text-lg text-purple hover:scale-125">check_circle_outline</span>
                                </button>
                             <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal284f9feb63bd47ce2d3752d7a9d26b19b33cab56)): ?>
<?php $component = $__componentOriginal284f9feb63bd47ce2d3752d7a9d26b19b33cab56; ?>
<?php unset($__componentOriginal284f9feb63bd47ce2d3752d7a9d26b19b33cab56); ?>
<?php endif; ?>
                        <?php endif; ?>
                    </div>

                    <div class="lex items-end justify-between">
                        <p class="text-black text-sm">
                            <?php echo $notification->data['description']; ?>

                        </p>
                    </div>
                </li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    <?php else: ?>
        <ul class="flex flex-col justify-center">
            <li class="text-sm mb-5">
                <div class="flex items-start">
                    <p class="text-black">
                        <?php echo e(trans('notifications.empty')); ?>

                    </p>
                </div>
            </li>
        </ul>
    <?php endif; ?>
</div>

<?php $__env->startPush('scripts_end'); ?>
    <script type="text/javascript">
        window.addEventListener('mark-read', event => {
            if (event.detail.type == 'notifications') {
                $.notify(event.detail.message, {
                    type: 'success',
                });
            }
        });

        window.addEventListener('mark-read-all', event => {
            if (event.detail.type == 'notifications') {
                $.notify(event.detail.message, {
                    type: 'success',
                });
            }
        });
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/accesse1/public_html/Web-Apps-Production/Akaunting-306/resources/views/livewire/menu/notifications.blade.php ENDPATH**/ ?>