<section id="page-title">

    <div class="container clearfix">

        <h4 class="nobottommargin" style="font-family: 'Lato', sans-serif"><?php echo __('Ticket ID : '); ?> #<?php echo $ticket->getNumber(); ?></h4>
        <ol class="breadcrumb">
            <li><a href="<?php echo ROOT_PATH; ?>index.php">Home &nbsp;&nbsp;</a></li>
            <li>/</li>
            <li class="active"><a href="<?php echo ROOT_PATH; ?>tickets.php">&nbsp;&nbsp; Tickete's</a></li>
        </ol>

    </div>

</section>

<section id="content">

    <div class="content-wrap" style="padding-top: 20px; padding-bottom:30px">

        <div class="container clearfix">

            <div class="col_full">
                <?php
                if(!defined('OSTCLIENTINC') || !$thisclient || !$ticket || !$ticket->checkUserAccess($thisclient)) die('Access Denied!');

                $info=($_POST && $errors)?Format::htmlchars($_POST):array();

                $type = array('type' => 'viewed');
                Signal::send('object.view', $ticket, $type);

                $dept = $ticket->getDept();

                if ($ticket->isClosed() && !$ticket->isReopenable())
                    $warn = sprintf(__('%s is marked as closed and cannot be reopened.'), __('This ticket'));

                //Making sure we don't leak out internal dept names
                if(!$dept || !$dept->isPublic())
                    $dept = $cfg->getDefaultDept();

                if ($thisclient && $thisclient->isGuest()
                    && $cfg->isClientRegistrationEnabled()) { ?>

                <div id="msg_info">
                    <i class="icon-compass icon-2x pull-left"></i>
                    <strong><?php echo __('Looking for your other tickets?'); ?></strong><br />
                    <a href="<?php echo ROOT_PATH; ?>login.php?e=<?php
                        echo urlencode($thisclient->getEmail());
                    ?>" style="text-decoration:underline"><?php echo __('Sign In'); ?></a>
                    <?php echo sprintf(__('or %s register for an account %s for the best experience on our help desk.'),
                        '<a href="account.php?do=create" style="text-decoration:underline">','</a>'); ?>
                    </div>

                <?php } ?>

                <div class="col_full" id="ticketInfo">
                    <tr>
                        <td colspan="2" width="100%">

                            <div class="col_three_fourth nobottommargin">
                                <h3 style="color: black">
                                    <a href="tickets.php?id=<?php echo $ticket->getId(); ?>" title="<?php echo __('Reload'); ?>"><i class="fad fa-sync-alt" style="color: green; margin-right: 10px;"></i></a>
                                    <b>
                                    <?php $subject_field = TicketForm::getInstance()->getField('subject');
                                        echo $subject_field->display($ticket->getSubject()); ?>
                                    </b>
                                </h3>
                            </div>

                            <div class="col_one_fourth col_last nobottommargin">
                                <div class="col_half">
                                    <h3 style="color: black">
                                        <a class="action-button" href="tickets.php?a=print&id=<?php
                                        echo $ticket->getId(); ?>"><i class="fad fa-print" style="color: blue; margin-right: 10px;"></i> <?php echo __('Print'); ?>
                                        </a>
                                    </h3>
                                </div>

                                <div class="col_half col_last">
                                    <h3 style="color: black">
                                        <?php if ($ticket->hasClientEditableFields()
                                                // Only ticket owners can edit the ticket details (and other forms)
                                                && $thisclient->getId() == $ticket->getUserId()) { ?>
                                                        <a class="action-button" href="tickets.php?a=edit&id=<?php
                                                             echo $ticket->getId(); ?>"><i class="fad fa-edit" style="color: blue; margin-right: 10px;"></i> <?php echo __('Edit'); ?></a>
                                        <?php } ?>
                                    </h3>
                                </div>
                            </div>
                        </td>
                    </tr>
                </div>

                <div class="line" style="margin: 30px"></div>

                <div class="col_full">
                    <tr>
                        <div class="col_half">
                            <table class="infoTable" cellspacing="1" cellpadding="3" width="100%" border="0">
                                 <thead>
                                    <tr>
                                        <h3 class="headline" colspan="2">
                                            <?php echo __('Basic Ticket Information'); ?>
                                        </h3>
                                    </tr>
                                </thead>
                                <tr>
                                    <th width="100"><?php echo __('Ticket Status');?>:</th>
                                    <td><?php echo ($S = $ticket->getStatus()) ? $S->getLocalName() : ''; ?></td>
                                </tr>
                                <tr>
                                    <th><?php echo __('Department');?>:</th>
                                    <td><?php echo Format::htmlchars($dept instanceof Dept ? $dept->getName() : ''); ?></td>
                                </tr>
                                <tr>
                                    <th><?php echo __('Create Date');?>:</th>
                                    <td><?php echo Format::datetime($ticket->getCreateDate()); ?></td>
                                </tr>
                           </table>
                       </div>
                           
                        <div class="col_half col_last">
                            <table class="infoTable" cellspacing="1" cellpadding="3" width="100%" border="0">
                                <thead>
                                    <tr>
                                        <h3 class="headline" colspan="2">
                                        <?php echo __('User Information'); ?>
                                        </h3>                                        
                                    </tr>
                                </thead>
                                <tr>
                                   <th width="100"><?php echo __('Name');?>:</th>
                                   <td><?php echo mb_convert_case(Format::htmlchars($ticket->getName()), MB_CASE_TITLE); ?></td>
                                </tr>
                                <tr>
                                   <th width="100"><?php echo __('Email');?>:</th>
                                   <td><?php echo Format::htmlchars($ticket->getEmail()); ?></td>
                                </tr>
                                <tr>
                                    <th><?php echo __('Phone');?>:</th>
                                    <td><?php echo $ticket->getPhoneNumber(); ?></td>
                                </tr>
                            </table>
                        </div>

                            <td colspan="2">
                                <!-- Custom Data -->
                                <?php
                                $sections = $forms = array();
                                foreach (DynamicFormEntry::forTicket($ticket->getId()) as $i=>$form) {
                                    // Skip core fields shown earlier in the ticket view
                                    $answers = $form->getAnswers()->exclude(Q::any(array(
                                        'field__flags__hasbit' => DynamicFormField::FLAG_EXT_STORED,
                                        'field__name__in' => array('subject', 'priority'),
                                        Q::not(array('field__flags__hasbit' => DynamicFormField::FLAG_CLIENT_VIEW)),
                                    )));
                                    // Skip display of forms without any answers
                                    foreach ($answers as $j=>$a) {
                                        if ($v = $a->display())
                                            $sections[$i][$j] = array($v, $a);
                                    }
                                    // Set form titles
                                    $forms[$i] = $form->getTitle();
                                }
                                foreach ($sections as $i=>$answers) {
                                    ?>

                                <table class="custom-data" cellspacing="0" cellpadding="4" width="100%" border="0">
                                    <tr>
                                        <td colspan="2" class="headline flush-left"><?php echo $forms[$i]; ?></th></tr>
                                        <?php foreach ($answers as $A) {
                                        list($v, $a) = $A; ?>
                                    <tr>
                                        <th><?php
                                            echo $a->getField()->get('label');
                                            ?>:
                                        </th>
                                        <td><?php
                                            echo $v;
                                            ?>
                                        </td>
                                    </tr>
                                        <?php } ?>
                                </table>
                                    <?php
                                } ?>
                        </td>
                    </tr>
                </div>

                <div class="line" style="margin: 15px"></div>

                <br>
                  <?php
                    $email = $thisclient->getUserName();
                    $clientId = TicketUser::lookupByEmail($email)->getId();

                    $ticket->getThread()->render(array('M', 'R', 'user_id' => $clientId), array(
                                    'mode' => Thread::MODE_CLIENT,
                                    'html-id' => 'ticketThread')
                                );
                if ($blockReply = $ticket->isChild() && $ticket->getMergeType() != 'visual')
                    $warn = sprintf(__('This Ticket is Merged into another Ticket. Please go to the %s%d%s to reply.'),
                        '<a href="tickets.php?id=', $ticket->getPid(), '" style="text-decoration:underline">Parent</a>');
                  ?>

                <div class="clear" style="padding-bottom:10px;"></div>
                <?php if($errors['err']) { ?>
                    <div id="msg_error"><?php echo $errors['err']; ?></div>
                <?php }elseif($msg) { ?>
                    <div id="msg_notice"><?php echo $msg; ?></div>
                <?php }elseif($warn) { ?>
                    <div id="msg_warning"><?php echo $warn; ?></div>
                <?php }
                if ((!$ticket->isClosed() || $ticket->isReopenable()) && !$blockReply) { ?>
                <form id="reply" action="tickets.php?id=<?php echo $ticket->getId();
                ?>#reply" name="reply" method="post" enctype="multipart/form-data">
                    <?php csrf_token(); ?>
                    <h2><?php echo __('Post a Reply');?></h2>
                    <input type="hidden" name="id" value="<?php echo $ticket->getId(); ?>">
                    <input type="hidden" name="a" value="reply">
                    <div>
                        <p><em><?php
                         echo __('To best assist you, we request that you be specific and detailed'); ?></em>
                        <font class="error">*&nbsp;<?php echo $errors['message']; ?></font>
                        </p>
                        <textarea name="message" id="message" cols="150" rows="9" wrap="soft"
                            class="<?php if ($cfg->isRichTextEnabled()) echo 'richtext';
                                ?> draft" <?php
                list($draft, $attrs) = Draft::getDraftAndDataAttrs('ticket.client', $ticket->getId(), $info['message']);
                echo $attrs; ?>><?php echo $draft ?: $info['message'];
                            ?></textarea>
                    <?php
                    if ($messageField->isAttachmentsEnabled()) {
                        print $attachments->render(array('client'=>true));
                    } ?>
                    </div>
                <?php
                  if ($ticket->isClosed() && $ticket->isReopenable()) { ?>
                    <div class="warning-banner">
                        <?php echo __('Ticket will be reopened on message post'); ?>
                    </div>
                <?php } ?>
                    <div class="col_full">
                        <p style="text-align:center">
                            <input class="button button-3d button-small button-rounded button-green" type="submit" value="<?php echo __('Post Reply');?>">
                            <input class="button button-3d button-small button-rounded button-blue" type="reset" value="<?php echo __('Reset');?>">
                            <input class="button button-3d button-small button-rounded button"type="button" value="<?php echo __('Cancel');?>" onClick="history.go(-1)">
                        </p>
                </form>
                <?php
                } ?>
                <script type="text/javascript">
                <?php
                // Hover support for all inline images
                $urls = array();
                foreach (AttachmentFile::objects()->filter(array(
                    'attachments__thread_entry__thread__id' => $ticket->getThreadId(),
                    'attachments__inline' => true,
                )) as $file) {
                    $urls[strtolower($file->getKey())] = array(
                        'download_url' => $file->getDownloadUrl(['type' => 'H']),
                        'filename' => $file->name,
                    );
                } ?>
                showImagesInline(<?php echo JsonDataEncoder::encode($urls); ?>);
                </script>
                </td>
            </tr>
        </div>
    </div>
</div>
</section>          